<?php

use App\Http\Controllers\OdooProductController;
use App\Http\Controllers\Api\EmployeeController;
use App\Http\Controllers\Api\JobOrderController;
use App\Http\Controllers\Api\SMSController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;


Route::get('/odoo/products', [OdooProductController::class, 'index']);

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::post('/send-otp', [SMSController::class, 'sendOTP']);

Route::resource('employees', EmployeeController::class);
Route::resource('job-orders', JobOrderController::class);
